//$4598SSI JOB (22220000,T772,,AIS,,OPE-19),4598JAH,
// CLASS=T,MSGCLASS=Q,NOTIFY=$4598
//*MAIN SYSTEM=(SY56)
//S1 EXEC SAS9
//WORK DD SPACE=(6160,(9000,9000),,,ROUND)
//SYSIN DD *
	/**/;

libname sbst1 'ais.p1252.$4598.sbst1';
libname sbst2 'ais.p1252.$4598.sbst2';

	*libname oresmbr 'ORES.DSSA.PRD.ORTAR.MBRPUB.R201112';
libname oresmbr2 'ORES.DSSA.PRD.ORTAR.MBRPUB.R201708' access=readonly;
libname CURPAY17 'ORES.DSSA.PRD.ORTAR.CURPAYS.R201707' access=readonly;

	/*Current Sample*/

data sbst2.master_ssdi (compress=yes
	keep=can boan bic laf bdod pia doec sift sisc mba age
		addr: age65 bgn bmn bln bica sexb racep erreduc reppayee
		hi_basis hi_active smi_basis smi_active nctzn dib_dig_1
		dual_type medstat red_for_age bclm_doe_start_1
		totben comben ctzn: doc);
	set oresmbr2.mbrpub (where=(age ge 65 and age le 80)); 

	if bdod=.; /*needs to be alive*/

	if laf in ('C','E'); /*in current pay*/

	if boan='' then boan=can;

	pia=pia_1;
	mba=mba_1;

	bica=(bic='A');

run;

proc sort data=sbst2.master_ssdi; by boan; run;

data sbst2.total_ssdi (keep=boan total_mba total_pia num_rec bic_a 
		compress=yes);
	set sbst2.master_ssdi;
	by boan;

	if first.boan then do;
		total_mba=0;
		total_pia=0;
		num_rec=0;
		bic_a=0;
	end;
		
	total_mba+mba;
	total_pia+pia;
	num_rec+1;
	bic_a+bica;

	if last.boan;

RUN;

proc sort data=sbst2.total_ssdi; by boan; run;

data sbst2.master_ssdi_ssi (compress=yes);
	merge sbst2.master_ssdi sbst2.total_ssdi;
	by boan;
	
	if SIFT in ('A','B','D','F','D','G','H') THEN SSI=1;
		else if SIFT in ('C','E','P','R','S','T') THEN SSI=2;
		ELSE SSI=0;

	potential_mba=(total_mba<755); /*735(FBR2017)+20*/
	potential_pia=(total_pia<755); /*735(FBR2017)+20*/

	pan=boan;

	if potential_mba=1 or potential_pia=1;

RUN;

proc sort data=sbst2.master_ssdi_ssi nodupkey; by pan; run;

data sbst2.sno_pan (keep=pan SNO_CD);
	set sbst1.sno_report;
	pan=ssn;
run;

proc sort data=sbst2.sno_pan nodupkey; by pan; run;

data sbst2.master_ssdi_ssi_sno; 
	merge sbst2.master_ssdi_ssi (in=a) sbst2.sno_pan;
	by pan;
	if a=1;
run;

data sbst2.sbst_finder_sno;
	set	sbst2.master_ssdi_ssi_sno (keep=pan);
run;

proc sort data=sbst2.sbst_finder_sno nodupkey; 
	by pan; run;


	/*Get who was on SSI at in 07/2017*/ 

data sbst2.curpay17 (compress=yes
		keep=pan mft17 pmt_sample17 pstat_sample17 term17 
		ssi_status pstat_cur17 rcd_est_jd);
	merge sbst2.sbst_finder_sno (in=a) CURPAY17.CURPAYS;
	*where put(pan,$master.)='Y';
	if a=1;

	mft17=mft;
	pstat_cur_sample17=(pstat_cur in ('C01','E01','E02'));
	pstat_sample17=(pstat in ('C01','E01','E02'));
	pmt_sample17=(fedpmt>0 | statpmt>0);

	if substr(pstat,1,1)='T' then term17=1;
		else if substr(pstat,1,1)='S' then term17=1;
		else if substr(pstat,1,1)=' ' then term17=1;
		else term17=0;
	pstat_cur17=pstat_cur;

	if substr(pstat,1,1)='C' OR substr(pstat,1,1)='E' 
			OR substr(pstat,1,1)='M' then ssi_status=1;
		else if substr(pstat,1,1)='N' then ssi_status=2;
		else if substr(pstat,1,1)='T' then ssi_status=3;
		else if substr(pstat,1,1)='S' then ssi_status=4; 
		else if substr(pstat,1,1)='H' then ssi_status=5;
		else if substr(pstat,1,1)='P' then ssi_status=6;
		else ssi_status=0; 

run;

proc sort data=sbst2.curpay17; by pan rcd_est_jd; run;

data sbst2.curpay17 (compress=yes drop=rcd_est_jd);
	set sbst2.curpay17;
	by pan;
	if last.pan=1;
run;

data sbst2.analysis17_final (compress=yes);
	merge sbst2.master_ssdi_ssi_sno (in=a) sbst2.curpay17;
	by pan;
	if a=1;

	either=(potential_mba=1 | potential_pia=1);

run;

proc sort data=sbst2.analysis17_final (compress=yes); 
	by doc; 
run;

	/*add office code info*/
data sbst2.ofcdphone (drop=ocd);
	set sbst2.medibofcd (keep=OCD PHNAREA PHNEXCH PHNNUM);
	DOC=OCD;

	fo_phone='1-'||catx('-',phnarea,phnexch,phnnum);
	if phnarea='' or phnarea='000' or phnarea='   ' then do;
		fo_phone='1-800-772-1213';
		national=1;
	end;
	else national=0;

run;
proc sort data=sbst2.ofcdphone (compress=yes) ; by doc; run;

data sbst2.analysis17_final (compress=yes);
	merge sbst2.analysis17_final (in=a) sbst2.ofcdphone;
	by doc;
	if a=1;

	if national=. then national=1;

	/*SSI Status from SISC*/
	if sisc='' then prior_ssi_status=0; /*No SSI Record*/
		else if sisc in('A','C','E','G','M','S') then prior_ssi_status=1; /*SSI Eligible*/
		else if sisc in('B','L','N','T','U','V','W','X') then prior_ssi_status=2; /*SSI Terminated*/
		else if sisc in('D',) then prior_ssi_status=3; /*SSI Denied*/
		else if sisc in('I') then prior_ssi_status=4; /*SSI Ineligible*/
		else if sisc in('P') then prior_ssi_status=5; /*SSI Pending*/
		else if sisc in('Y','Z') then prior_ssi_status=6; /*Non-pay, income or resources*/
		else prior_ssi_status=7;
		/*keep if prior_ssi_status in (0,2,3,4)*/
run;

